﻿namespace Microscopic_Traffic_Simulator.ViewModels
{
    /// <summary>
    /// Interface of application settings.
    /// </summary>
    interface ISettings
    {
        /// <summary>
        /// Item for path to file where is the last opened topology.
        /// </summary>
        string LastGeometricTopologyPath { get; set; }

        /// <summary>
        /// Seed which was used in the last simulation.
        /// </summary>
        int PreviousSeed { get; set; }

        /// <summary>
        /// Determines whether there is any previous seed (whether any simulation was running in past).
        /// </summary>
        bool PreviousSeedNull { get; set; }

        /// <summary>
        /// Determines whether the seed is initialized automatically.
        /// </summary>
        bool IsSeedSettingAutomatic { get; set; }

        /// <summary>
        /// Determines whether the seed from previous simulation run is used.
        /// </summary>
        bool IsPreviousSeedUsed { get; set; }

        /// <summary>
        /// Path to last used file with parameters.
        /// </summary>
        string PathToParameters { get; set; }

        /// <summary>
        /// Saves application settings.
        /// </summary>
        void Save();
    }
}
